//
//  IdentityProvider.h
//  dJAX
//
//  Copyright (c) 2015 dJAX. All rights reserved.
//

#import <Foundation/Foundation.h>

@interface IdentityProvider : NSObject

+ (NSString *)identifier;
+ (NSString *)obfuscatedIdentifier;
+ (BOOL)advertisingTrackingEnabled;

/**
 * A Boolean value indicating whether the dJAX SDK should create a dJAX ID that can be used
 * for frequency capping when Limit ad tracking is on & the IDFA we get is
 * 00000000-0000-0000-0000-000000000000.
 *
 * When set to NO, the SDK will not create a dJAX ID in the above case. When set to YES, the
 * SDK will generate a dJAX ID. The default value is YES.
 *
 */
+ (void)setFrequencyCappingIdUsageEnabled:(BOOL)frequencyCappingIdUsageEnabled;
+ (BOOL)frequencyCappingIdUsageEnabled;

@end
